--   timer, first_timer   Params.Triggers
require( "scripts/game/deftime.lua" );
require( "scripts/game/deftasks.lua" );
--    
GameObject = {
    Params = {
        ID="dog_point";
        width=0;
        height=0;
        not_visual = 1;
        RandomTasks=0;
        iCurrentIndex=0;
        iRandomTicker=0;
    };
    ActivePoints = { 
        moving = { 
                   { {}, 0,0,0,  0,  0,0,0 };
                   }; 
    };
    Points = 
    {
        { {"dog"}, 7,6 },
        { {"dog"}, 10,7 },
        { {"dog"}, 13,10 },
        { {"dog"}, 16, 4 },
        { {"dog"}, 23,-1 },
        { {"dog"}, 34,-5 },
        { {"dog"}, 29,-10 },
        { {"dog"}, 22,-6 },
        { {"dog"}, 23,-16 },
        { {"dog"}, 15,-14 },
        { {"dog"}, 14,-3 },
        { {"dog"}, 8,-7 },
        { {"dog"}, 7,1 },
        { {"dog"}, 15,-1 },
        
        
        { {"dog"}, 7,6 },
        { {"dog"}, 10,7 },
        { {"dog"}, 13,10 },
        { {"dog"}, 16, 4 },
        { {"dog"}, 23,-1 },
        { {"dog"}, 34,-5 },
        { {"dog"}, 29,-10 },
        { {"dog"}, 22,-6 },
        { {"dog"}, 23,-16 },
        { {"dog"}, 15,-14 },
        { {"dog"}, 14,-3 },
        { {"dog"}, 8,-7 },
        { {"dog"}, 7,1 },
        { {"dog"}, 15,-1 }
    };
    
    Objects = {};
    --     
    Tasks = {
        moving = { FuncName="DogMovingTaskExecute", skill_up = 0, not_need_action=1, hand_add=1 };
    };
    --     
    Triggers = {  
        WishMoving = {FuncName="WishMovingTriger", timer={5,7,10}, first_timer={ 2,3 }};
    };
    --      
    InitActiveTasks = {};
    --      
};


function GameObject:Get()
    return self;
end


function SetPoint(aIndex)
    local Index = aIndex;
    aObj = GameObject:Get();    
    local Count =  table.getn(aObj.Points);
    
    if( Count==0)then return end;
    if( Index<=0)then Index = Count; end;
    if( Index>Count)then Index = 1; end;
    aObj.Params.iCurrentIndex = Index;
    aObj.ActivePoints.moving[1] = aObj.Points[Index];
    CPP_ReReadPoints();
    CPP_PutOnTopExpectedTasks("moving");    
end







function WishMovingTriger()
    aObj = GameObject:Get();    
    if (aObj.Params.iRandomTicker == 0) then
        aObj.Params.iRandomTicker = GetTriggerTimerRand(aObj.Triggers.WishMoving);
        return;
    end
    
    aObj.Params.iRandomTicker = aObj.Params.iRandomTicker - 1;
    if (aObj.Params.iRandomTicker <= 0) then
        --SetPoint(aObj.Params.iCurrentIndex+1);
        
        local r;
        repeat 
            r = Random(1, table.getn(aObj.Points));
        until not(r == last_point and table.getn(aObj.Points)>1);
        
        last_point = r;
        SetPoint( r );
    end
end


function DogMovingTaskExecute()
    aObj.ActivePoints.moving[0] = nil;
    return 0;
end
